$(function(){
    
	/***************************************************************************************************************/	
	/* 1. Load Tooltips															   				   				   */
	/***************************************************************************************************************/
	
	//we're using tippy for the tooltip
	tippy('[data-tippy-content]',{
		trigger: 'click',
		placement: 'bottom',
		boundary: 'window',
		arrow: true
	});
	
	/***************************************************************************************************************/	
	/* 2. Widget Data														   				   				   	   */
	/***************************************************************************************************************/
	
	//populate the datasource label
	populate_datasource_title();

	//attach event to the Data Option dropdown
	$('#ew_chart_enable_filter').on('change', function() {
		var selected_value = $(this).val();
		
		if(selected_value == 1){
			$("#widget_filter_pane").slideDown();
		}else{
			$("#widget_filter_pane").slideUp();
		}
	});

	//delegate change event into filter field name dropdown
	$('#widget_filter_pane').on('change', 'select.condition_fieldname', function(e) {
			var new_element_name = $(this).val();
			var new_element_type = $("#widget_filter_pane").data(new_element_name);

			$(this).parent().find('.condition_text,.condition_time,.condition_number,.condition_date,.condition_file,.condition_checkbox,.condition_approval_status,.condition_time,.filter_keyword,.condition_select,.condition_rating,.condition_ratingvalues').hide();
			$(this).parent().removeClass('filter_date');

			//reset keyword
			$(this).parent().data('filter_properties').keyword = '';
			$(this).parent().find('.filter_keyword').val('');

			//display the appropriate condition type dropdown, depends on the field type
			//and make sure to update the condition property value when the field type has been changed
			if(new_element_type == 'money' || new_element_type == 'number'){
				$(this).parent().find('.condition_number,input.text').show();
				$(this).parent().data('filter_properties').condition = $(this).parent().find('.condition_number').val();
			}else if(new_element_type == 'date' || new_element_type == 'europe_date'){
				$(this).parent().addClass('filter_date');
				$(this).parent().find('.condition_date,input.text').show();
				$(this).parent().data('filter_properties').condition = $(this).parent().find('.condition_date').val();
			}else if(new_element_type == 'time' || new_element_type == 'time_showsecond' || new_element_type == 'time_24hour' || new_element_type == 'time_showsecond24hour'){
				
				$(this).parent().find('.condition_date,.condition_time').show();
				
				$(this).parent().find('.condition_time .conditiontime_second,.condition_time .conditiontime_ampm').hide();
				
				if(new_element_type == 'time'){
					$(this).parent().find('.condition_time .conditiontime_ampm').show();
				}else if(new_element_type == 'time_showsecond'){
					$(this).parent().find('.condition_time .conditiontime_ampm,.condition_time .conditiontime_second').show();
				}else if(new_element_type == 'time_showsecond24hour'){
					$(this).parent().find('.condition_time .conditiontime_second').show();
				}

				$(this).parent().data('filter_properties').condition = $(this).parent().find('.condition_date').val();
			}else if(new_element_type == 'radio' || new_element_type == 'select'){
				//reset condition type
				$(this).parent().find('.condition_text').show().val('is');
				$(this).parent().data('filter_properties').condition = 'is';

				//reset condition keyword with dropdown values and display it
				$(this).parent().find('.condition_select').html($("#" + new_element_name + "_lookup").html()).show();
				$(this).parent().data('filter_properties').keyword = $(this).parent().find('.condition_select').eq(0).val();
			}else if(new_element_type == 'rating'){
				//reset condition type
				$(this).parent().find('.condition_rating').show().val('is');
				$(this).parent().data('filter_properties').condition = 'is';

				//reset condition keyword with dropdown values and display it
				$(this).parent().find('.condition_ratingvalues').html($("#" + new_element_name + "_lookup").html()).show();
				$(this).parent().data('filter_properties').keyword = $(this).parent().find('.condition_ratingvalues').eq(0).val();
			}else if(new_element_type == 'file'){
				$(this).parent().find('.condition_file,input.text').show();
				$(this).parent().data('filter_properties').condition = $(this).parent().find('.condition_file').val();
			}else if(new_element_type == 'checkbox'){
				$(this).parent().find('.condition_checkbox').show();
				$(this).parent().data('filter_properties').condition = $(this).parent().find('.condition_checkbox').val();
			}else if(new_element_type == 'approval_status'){
				$(this).parent().find('.condition_approval_status').show();
				$(this).parent().data('filter_properties').condition = $(this).parent().find('.condition_approval_status').val();
			}else{
				$(this).parent().find('.condition_text,input.text').show();
				$(this).parent().data('filter_properties').condition = $(this).parent().find('.condition_text').val();
			}

			$(this).parent().data('filter_properties').element_name = new_element_name;
    });

	 //delegate change event to the condition type dropdown (for number, date, checkbox, rating)
    $('#widget_filter_pane').on('change', 'select.condition_number,select.condition_date,select.condition_file,select.condition_checkbox,select.condition_approval_status,select.condition_rating', function(e) {
		$(this).parent().data('filter_properties').condition = $(this).val();
    });

      //delegate change event to the condition type dropdown (for other fields beside the above)
    $('#widget_filter_pane').on('change', 'select.condition_text', function(e) {
    	var element_name = $(this).parent().data('filter_properties').element_name;
    	var element_type = $("#widget_filter_pane").data(element_name);

    	var condition_type = $(this).val();
    	
    	//if the field type is radio/dropdown, check for the selected condition type
    	//if condition type = 'is'/'is_not' , display the dropdown
    	if(element_type == 'radio' || element_type == 'select'){
    		$(this).parent().find('.filter_keyword,.condition_select').hide();

    		if(condition_type == 'is' || condition_type == 'is_not'){
    			$(this).parent().find('.condition_select').show();
    			$(this).parent().data('filter_properties').keyword = $(this).parent().find('.condition_select').eq(0).val();
    		}else{
    			$(this).parent().find('.filter_keyword').show();
    			$(this).parent().data('filter_properties').keyword = $(this).parent().find('.filter_keyword').val();
    		}
    	}

		$(this).parent().data('filter_properties').condition = condition_type;
    });

    //delegate change event to the condition select dropdown (only applicable for radio and select)
    $('#widget_filter_pane').on('change', 'select.condition_select', function(e) {
		$(this).parent().data('filter_properties').keyword = $(this).val();
    });

    //delegate change event to the condition select dropdown (only applicable for rating)
    $('#widget_filter_pane').on('change', 'select.condition_ratingvalues', function(e) {
		$(this).parent().data('filter_properties').keyword = $(this).val();
    });

    //delegate event to the filter keyword text
    $('#widget_filter_pane').on('keyup mouseout change', 'input.filter_keyword', function(e) {
		$(this).parent().data('filter_properties').keyword = $(this).val();	
    });

    //delegate event to the time condition inputs
    $('#widget_filter_pane').on('keyup mouseout change', 'input.conditiontime_input,select.conditiontime_input', function(e) {
		
		var temp = $(this).attr("id").split("_");

		var hour_value 	 = parseInt($("#conditiontimehour_" + temp[1]).val(),10);
		var minute_value = parseInt($("#conditiontimeminute_" + temp[1]).val(),10);
		var second_value = parseInt($("#conditiontimesecond_" + temp[1]).val(),10);
		
		var ampm_value 	 = $("#conditiontimeampm_" + temp[1]).val();

		if(isNaN(hour_value)){
			hour_value = '00';
		}

		if(isNaN(minute_value)){
			minute_value = '00';
		}
		
		if(isNaN(second_value)){
			second_value = '00';
		}

		$("#li_" + temp[1]).data('filter_properties').keyword = hour_value.toString() + ':' + minute_value.toString() + ':' + second_value.toString() + ':' + ampm_value;
    });

    //delegate click event to the delete filter condition icon
    $('#widget_filter_pane').on('click', 'a.filter_delete_a', function(e) {
		
		if($("#widget_filter_pane li:not('.filter_add')").length <= 1){
			Swal.fire({
				title: 'Unable to delete',
				html: `You can't delete all filter condition! <br/>You must have at least 1 filter condition.`,
				customClass: {
					title: 'swal2-title-warning',
					htmlContainer: 'swal2-html-container-bold'
				},
				icon: 'error',
				width: '30%',
				allowOutsideClick: true
			});
		}else{
			$(this).parent().fadeOut(function(){
				$(this).remove();
			});
		}

		return false;
    });

    //attach click event to 'add filter condition' icon
	$("#filter_add_a").on('click',function(){
		var new_id = $("#widget_filter_pane li:not('.filter_add')").length + 1;
		var old_id = new_id - 1;
		
		//duplicate the last filter condition
		var last_filter_element = $("#widget_filter_pane ul > li:not('.filter_add')").last();
		last_filter_element.clone(false).data('filter_properties',$.extend('{}',last_filter_element.data('filter_properties'))).find("*[id],*[name]").each(function() {
			var temp = $(this).attr("id").split("_"); 
			var old_id = new_id - 1;

			//rename the original id with the new id
			$(this).attr("id", temp[0] + "_" + new_id);
			$(this).attr("name", temp[0] + "_" + new_id);
			
		}).end().attr("id","li_" + new_id).insertBefore("#li_filter_add").hide().fadeIn();

		//copy the value of the dropdowns
		$("#filterfield_" + new_id).val($("#filterfield_" + old_id).val());
		$("#conditiontext_" + new_id).val($("#conditiontext_" + old_id).val());
		$("#conditionnumber_" + new_id).val($("#conditionnumber_" + old_id).val());
		$("#conditiondate_" + new_id).val($("#conditiondate_" + old_id).val());
		$("#conditionfile_" + new_id).val($("#conditionfile_" + old_id).val());
		$("#conditioncheckbox_" + new_id).val($("#conditioncheckbox_" + old_id).val());
		
		//reset the filter keyword  
		$("#filterkeyword_" + new_id).val('');
		$("#li_" + new_id).data('filter_properties').keyword = '';

		//remove the datepicker and rebuild it, with the events as well
		$('#datepicker_' + new_id).next().next().remove();
		$('#datepicker_' + new_id).next().remove();
		$('#datepicker_' + new_id).remove();

		var new_datepicker_tag = '<input type="hidden" value="" name="datepicker_'+ new_id +'" id="datepicker_'+ new_id +'">' +
								 '<span style="display:none"><img id="datepickimg_'+ new_id +'" alt="Pick date." src="images/icons/calendar.png" class="trigger filter_date_trigger" style="vertical-align: top; cursor: pointer" /></span>';

		$('#filterkeyword_' + new_id).after(new_datepicker_tag);

		$('#datepicker_' + new_id).datepick({ 
	    		onSelect: select_date,
	    		showTrigger: '#datepickimg_' + new_id
		});

		return false;
	});

	/***************************************************************************************************************/	
	/* 2. Widget Options															   				   			   */
	/***************************************************************************************************************/

	//initialize chart Background Color picker
	$("#ew_chart_background").kendoColorPicker({
		clearButton: true,
		palette: "basic",
		format: "hex",
		formats: ["rgb", "hex"]
	});

	//initialize chart Bar Color picker
	$("#ew_chart_bar_color").kendoColorPicker({
		clearButton: true,
		palette: "basic",
		format: "hex",
		formats: ["rgb", "hex"]
	});

	//attach event to 'Show Title' checkbox
	$('#ew_show_title').on('change', function() {
		if($(this).prop("checked") == true){
			$("#ew_show_title_div").slideDown();
		}else{
			$("#ew_chart_title").val('');
			$("#ew_show_title_div").slideUp();
		}
	});

	//attach event to 'Show Labels' checkbox
	$('#ew_show_labels').on('change', function() {
		if($(this).prop("checked") == true){
			$("#ew_show_labels_div").slideDown();
		}else{
			$("#ew_show_labels_div").slideUp();
		}
	});

	//attach event to the 'Show Labels - Position' dropdown
	$('#ew_chart_labels_position').on('change', function() {
		var selected_value = $(this).val();
		var chart_type = $("#ew_main_list").data("charttype");

		//labels alignment only available on pie, donut when the position is outsideEnd
		if(chart_type == 'pie' || chart_type == 'donut'){
			if(selected_value == 'outsideEnd'){
				$("#ew_chart_labels_align_span").show();
			}else{
				$("#ew_chart_labels_align_span").hide();
			}
		}
	});

	//attach event to 'Show Legend' checkbox
	$('#ew_show_legend').on('change', function() {
		if($(this).prop("checked") == true){
			$("#ew_show_legend_div").slideDown();
		}else{
			$("#ew_show_legend_div").slideUp();
		}
	});

	//attach event to 'Show Tooltip' checkbox
	$('#ew_show_tooltip').on('change', function() {
		if($(this).prop("checked") == true){
			$("#ew_show_tooltip_div").slideDown();
		}else{
			$("#ew_show_tooltip_div").slideUp();
		}
	});

	//attach event to the 'Date Range' dropdown
	$('#ew_chart_date_range').on('change', function() {
		var selected_value = $(this).val();
		
		//hide all options first
		$("#ew_show_date_range_period_div,#ew_show_date_range_custom_div").hide();
		if(selected_value == 'period'){
			$("#ew_show_date_range_period_div").show();
		}else if(selected_value == 'custom'){
			$("#ew_show_date_range_custom_div").show();
		}
	});

	/***************************************************************************************************************/	
	/* 3. Widget Size															   				   				   */
	/***************************************************************************************************************/

	//attach event to the Widget Height dropdown
	$('#ew_chart_height').on('change', function() {
		var selected_value = $(this).val();
		
		if(selected_value == 'custom'){
			$("#custom_widget_height_div").slideDown();
		}else{
			$("#custom_widget_height_div").slideUp();
		}
	});

	/***************************************************************************************************************/	
	/* 4. Initialize Datepickers												   				   				   */
	/***************************************************************************************************************/

	//initialize datepicker
	var total_filter = $("#widget_filter_pane li").length - 1;
	for(i=1;i<=total_filter;i++){
		$('#datepicker_' + i).datepick({ 
	    		onSelect: select_date,
	    		showTrigger: '#datepickimg_' + i
		});
	}

	//initialize date range start
	$('#datepicker_chart_date_range_start').datepick({ 
	    onSelect: select_date_range_start,
	    showTrigger: '#datepickimg_chart_date_range_start'
	});

	//initialize date range end
	$('#datepicker_chart_date_range_end').datepick({ 
	    onSelect: select_date_range_end,
	    showTrigger: '#datepickimg_chart_date_range_end'
	});

	
	/***************************************************************************************************************/	
	/* 6. Attach event to 'Save Settings' button												   				   */
	/***************************************************************************************************************/

	$("#button_save_widget").on('click',function(){
		
		if($("#button_save_widget").text() != 'Saving...'){
				
				//display loader while saving
				$("#button_save_widget").prop("disabled",true);
				$("#button_save_widget").text('Saving...');
				$("#button_save_widget").after("<div class='small_loader_box' style='float: right'><img src='images/loader_small_grey.gif' /></div>");
				
				var form_id  = $("#ew_main_list").data("formid");
				var chart_id = $("#ew_main_list").data("chartid");

				//get filter properties
				var filter_prop_array = new Array();
				$("#widget_filter_pane li.filter_settings").each(function(index){
					filter_prop_array[index] = $(this).data("filter_properties");
				});

				var chart_labels_visible_value = 0;
				if($("#ew_show_labels").prop("checked")){
					chart_labels_visible_value = 1;
				}

				var chart_rating_bars_visible_value = 0;
				if($("#ew_show_rating_bars").prop("checked")){
					chart_rating_bars_visible_value = 1;
				}

				var chart_rating_total_visible_value = 0;
				if($("#ew_show_rating_total_entries").prop("checked")){
					chart_rating_total_visible_value = 1;
				}

				var chart_legend_visible_value = 0;
				if($("#ew_show_legend").prop("checked")){
					chart_legend_visible_value = 1;
				}

				var chart_tooltip_visible_value = 0;
				if($("#ew_show_tooltip").prop("checked")){
					chart_tooltip_visible_value = 1;
				}

				var chart_gridlines_visible_value = 0;
				if($("#ew_show_gridlines").prop("checked")){
					chart_gridlines_visible_value = 1;
				}

				var chart_is_stacked_value = 0;
				if($("#ew_chart_is_stacked").prop("checked")){
					chart_is_stacked_value = 1;
				}

				var chart_is_vertical_value = 0;
				if($("#ew_chart_is_vertical").prop("checked")){
					chart_is_vertical_value = 1;
				}

				var selected_grid_columns = $("#li_grid_columns input.checkbox:checked").serializeArray();
				var csrf_token = $("#content").data("csrftoken");

				//send to backend using ajax call
				axios.post('save_widget_settings.php', {
					form_id: form_id,
					chart_id: chart_id,
					csrf_token: csrf_token,
					chart_enable_filter: $("#ew_chart_enable_filter").val(),
					filter_prop: filter_prop_array,
					filter_type: $("#filter_all_any").val(),
					chart_theme: $("#ew_chart_theme").val(),
					chart_line_style: $("#ew_chart_line_style").val(),
					chart_background: $("#ew_chart_background").val(),
					chart_bar_color: $("#ew_chart_bar_color").val(),
					chart_title: $("#ew_chart_title").val(),
					chart_title_position: $("#ew_chart_title_position").val(),
					chart_title_align: $("#ew_chart_title_align").val(),
					chart_labels_template: $("#ew_chart_labels_template").val(),
					chart_labels_visible: chart_labels_visible_value,
					chart_labels_position: $("#ew_chart_labels_position").val(),
					chart_labels_align: $("#ew_chart_labels_align").val(),
					chart_legend_visible: chart_legend_visible_value,
					chart_legend_position: $("#ew_chart_legend_position").val(),
					chart_tooltip_template: $("#ew_chart_tooltip_template").val(),
					chart_tooltip_visible: chart_tooltip_visible_value,
					chart_gridlines_visible: chart_gridlines_visible_value,
					chart_rating_bars_visible: chart_rating_bars_visible_value,
					chart_rating_total_visible: chart_rating_total_visible_value,
					chart_rating_size: $("input[name='ew_rating_size']:checked").val(),
					chart_is_stacked: chart_is_stacked_value,
					chart_is_vertical: chart_is_vertical_value,
					chart_date_range: $("#ew_chart_date_range").val(),
					chart_date_period_value: $("#ew_chart_date_period_value").val(),
					chart_date_period_unit: $("#ew_chart_date_period_unit").val(),
					chart_date_axis_baseunit_period: $("#ew_chart_date_axis_baseunit_period").val(),
					chart_date_axis_baseunit_custom: $("#ew_chart_date_axis_baseunit_custom").val(),
					chart_date_range_start: $("#ew_chart_date_range_start").val(),
					chart_date_range_end: $("#ew_chart_date_range_end").val(),
					grid_columns: selected_grid_columns,
					chart_grid_page_size: $("#ew_grid_page_size").val(),
					chart_grid_max_length: $("#ew_grid_max_length").val(),
					chart_height: $("#ew_chart_height").val(),
					chart_height_custom: $("#ew_chart_height_custom").val(),
					chart_grid_sort_by: $("#ew_chart_grid_sort_by").val()
				})
				.then(function (response) {
					if(response.data.status == 'ok'){
						window.location.replace('manage_report.php?id=' + response.data.form_id);
					}else{
						Swal.fire({
							width: '30%',
							position: 'center',
							icon: 'error',
							title: 'Error. Unable to complete the task.',
							html: response.data,
							showConfirmButton: false,
							showCancelButton: true,
							cancelButtonText: 'Close',
							allowOutsideClick: true
						});
					}
				})
				.catch(function (error) {
					Swal.fire({
						width: '30%',
						position: 'center',
						icon: 'error',
						title: 'Error. Unable to complete the task.',
						html: error,
						showConfirmButton: false,
						showCancelButton: true,
						cancelButtonText: 'Close',
						allowOutsideClick: true
					});
				});
		}
		
		
		return false;
	});

	/***************************************************************************************************************/	
	/* 7. KendoUI widgets																		   				   */
	/***************************************************************************************************************/
	let data_ew_chart_theme = [
        {ThemeValue: "default-main", 			ThemeColor1: "#ff6358",ThemeColor2: "#666666",ThemeColor3: "#03a9f4", ThemeName: "Default - Main" },
		{ThemeValue: "default-main-dark", 		ThemeColor1: "#EA5A51",ThemeColor2: "#C2C2C2",ThemeColor3: "#03A9F4", ThemeName: "Default - Main Dark" },
		{ThemeValue: "default-blue", 			ThemeColor1: "#23bde0",ThemeColor2: "#f6f6f6",ThemeColor3: "#03a9f4", ThemeName: "Default - Blue" },
		{ThemeValue: "default-ocean-blue", 		ThemeColor1: "#1274AC",ThemeColor2: "#757575",ThemeColor3: "#007F84", ThemeName: "Default - Ocean Blue" },
		{ThemeValue: "default-ocean-blue-a11y", ThemeColor1: "#1274AC",ThemeColor2: "#757575",ThemeColor3: "#007F84", ThemeName: "Default - Ocean Blue A11Y" },
		{ThemeValue: "default-nordic", 			ThemeColor1: "#1274AC",ThemeColor2: "#d6e5e9",ThemeColor3: "#03a9f4", ThemeName: "Default - Nordic" },
		{ThemeValue: "default-purple", 			ThemeColor1: "#bf70cc",ThemeColor2: "#f6f6f6",ThemeColor3: "#03a9f4", ThemeName: "Default - Purple" },
		{ThemeValue: "default-turquoise", 		ThemeColor1: "#28bfba",ThemeColor2: "#f6f6f6",ThemeColor3: "#03a9f4", ThemeName: "Default - Turquoise" },
		{ThemeValue: "default-dataviz-v4", 		ThemeColor1: "#ff6358",ThemeColor2: "#666666",ThemeColor3: "#03a9f4", ThemeName: "Default - Dataviz" },
		{ThemeValue: "default-green", 			ThemeColor1: "#53b827",ThemeColor2: "#f6f6f6",ThemeColor3: "#03a9f4", ThemeName: "Default - Green" },
		{ThemeValue: "default-orange", 			ThemeColor1: "#ff9411",ThemeColor2: "#f6f6f6",ThemeColor3: "#03a9f4", ThemeName: "Default - Orange" },
		{ThemeValue: "default-urban", 			ThemeColor1: "#ff5c1a",ThemeColor2: "#73a9c9",ThemeColor3: "#03a9f4", ThemeName: "Default - Urban" },
		{ThemeValue: "bootstrap-main", 			ThemeColor1: "#0d6efd",ThemeColor2: "#6c757d",ThemeColor3: "#6f42c1", ThemeName: "Bootstrap - Main" },
		{ThemeValue: "bootstrap-main-dark", 	ThemeColor1: "#0D6EFD",ThemeColor2: "#6C757D",ThemeColor3: "#6F42C1", ThemeName: "Bootstrap - Main Dark" },
		{ThemeValue: "bootstrap-4", 			ThemeColor1: "#007bff",ThemeColor2: "#6c757d",ThemeColor3: "#6f42c1", ThemeName: "Bootstrap - V4" },
		{ThemeValue: "bootstrap-4-dark", 		ThemeColor1: "#007bff",ThemeColor2: "#6c757d",ThemeColor3: "#6f42c1", ThemeName: "Bootstrap - V4 Dark" },
		{ThemeValue: "bootstrap-3", 			ThemeColor1: "#337ab7",ThemeColor2: "#f8f8f8",ThemeColor3: "#6f42c1", ThemeName: "Bootstrap - V3" },
		{ThemeValue: "bootstrap-3-dark", 		ThemeColor1: "#337ab7",ThemeColor2: "#f8f8f8",ThemeColor3: "#6f42c1", ThemeName: "Bootstrap - V3 Dark" },
		{ThemeValue: "bootstrap-dataviz-v4", 	ThemeColor1: "#0d6efd",ThemeColor2: "#6c757d",ThemeColor3: "#6f42c1", ThemeName: "Bootstrap - Dataviz" },
		{ThemeValue: "bootstrap-nordic", 		ThemeColor1: "#e7607b",ThemeColor2: "#d6e5e9",ThemeColor3: "#6f42c1", ThemeName: "Bootstrap - Nordic" },
		{ThemeValue: "bootstrap-turquoise", 	ThemeColor1: "#34d293",ThemeColor2: "#f1f4f1",ThemeColor3: "#6f42c1", ThemeName: "Bootstrap - Turquoise" },
		{ThemeValue: "bootstrap-turquoise-dark",ThemeColor1: "#10c4b2",ThemeColor2: "#6c757d",ThemeColor3: "#6f42c1", ThemeName: "Bootstrap - Turquoise Dark" },
		{ThemeValue: "bootstrap-urban", 		ThemeColor1: "#ff5c1a",ThemeColor2: "#73a9c9",ThemeColor3: "#6f42c1", ThemeName: "Bootstrap - Urban" },
		{ThemeValue: "bootstrap-vintage", 		ThemeColor1: "#744662",ThemeColor2: "#e8e3d6",ThemeColor3: "#6f42c1", ThemeName: "Bootstrap - Vintage" },
		{ThemeValue: "material-main", 			ThemeColor1: "#3f51b5",ThemeColor2: "#e51a5f",ThemeColor3: "#00695c", ThemeName: "Material - Main" },
		{ThemeValue: "material-main-dark", 		ThemeColor1: "#9FA8DA",ThemeColor2: "#F2A7BF",ThemeColor3: "#8CDACE", ThemeName: "Material - Main Dark" },
		{ThemeValue: "material-arctic", 		ThemeColor1: "#1565c0",ThemeColor2: "#00695c",ThemeColor3: "#00695c", ThemeName: "Material - Arctic" },
		{ThemeValue: "material-lime", 			ThemeColor1: "#2e7d32",ThemeColor2: "#1565c0",ThemeColor3: "#00695c", ThemeName: "Material - Lime" },
		{ThemeValue: "material-lime-dark", 		ThemeColor1: "#cddc39",ThemeColor2: "#03a9f4",ThemeColor3: "#009688", ThemeName: "Material - Lime Dark" },
		{ThemeValue: "material-nova", 			ThemeColor1: "#e51a5f",ThemeColor2: "#0277bd",ThemeColor3: "#00695c", ThemeName: "Material - Nova" },
		{ThemeValue: "material-aqua-dark", 		ThemeColor1: "#00bcd4",ThemeColor2: "#ffc107",ThemeColor3: "#009688", ThemeName: "Material - Aqua Dark" },
		{ThemeValue: "material-burnt-teal", 	ThemeColor1: "#00695c",ThemeColor2: "#ef6c00",ThemeColor3: "#00695c", ThemeName: "Material - Burnt Teal" },
		{ThemeValue: "material-dataviz-v4", 	ThemeColor1: "#3f51b5",ThemeColor2: "#e51a5f",ThemeColor3: "#00695c", ThemeName: "Material - Dataviz" },
		{ThemeValue: "material-eggplant", 		ThemeColor1: "#673ab7",ThemeColor2: "#2e7d32",ThemeColor3: "#00695c", ThemeName: "Material - Eggplant" },
		{ThemeValue: "material-pacific", 		ThemeColor1: "#3f51b5",ThemeColor2: "#1565c0",ThemeColor3: "#00695c", ThemeName: "Material - Pacific" },
		{ThemeValue: "material-pacific-dark", 	ThemeColor1: "#009688",ThemeColor2: "#2196f3",ThemeColor3: "#009688", ThemeName: "Material - Pacific Dark" },
		{ThemeValue: "material-sky", 			ThemeColor1: "#1565c0",ThemeColor2: "#e51a5f",ThemeColor3: "#00695c", ThemeName: "Material - Sky" },
		{ThemeValue: "material-sky-dark", 		ThemeColor1: "#2196f3",ThemeColor2: "#f48fb1",ThemeColor3: "#009688", ThemeName: "Material - Sky Dark" },
		{ThemeValue: "material-smoke", 			ThemeColor1: "#37474f",ThemeColor2: "#e51a5f",ThemeColor3: "#00695c", ThemeName: "Material - Smoke" },
		{ThemeValue: "fluent-main", 			ThemeColor1: "#0078d4",ThemeColor2: "#979593",ThemeColor3: "#2b88d8", ThemeName: "Fluent" },
		{ThemeValue: "classic-main", 			ThemeColor1: "#f35800",ThemeColor2: "#b6b6b6",ThemeColor3: "#03a9f4", ThemeName: "Classic - Main" },
		{ThemeValue: "classic-main-dark", 		ThemeColor1: "#f35800",ThemeColor2: "#e9e9e9",ThemeColor3: "#03a9f4", ThemeName: "Classic - Main Dark" },
		{ThemeValue: "classic-metro", 			ThemeColor1: "#618000",ThemeColor2: "#2c232b",ThemeColor3: "#03a9f4", ThemeName: "Classic - Metro" },
		{ThemeValue: "classic-metro-dark", 		ThemeColor1: "#008381",ThemeColor2: "#2c232b",ThemeColor3: "#03a9f4", ThemeName: "Classic - Metro Dark" },
		{ThemeValue: "classic-moonlight",		ThemeColor1: "#f4af03",ThemeColor2: "#212a33",ThemeColor3: "#03a9f4", ThemeName: "Classic - Moonlight" },
		{ThemeValue: "classic-green", 			ThemeColor1: "#3ea44e",ThemeColor2: "#f3f4f3",ThemeColor3: "#03a9f4", ThemeName: "Classic - Green" },
		{ThemeValue: "classic-lavender", 		ThemeColor1: "#9e5da9",ThemeColor2: "#f6f6f6",ThemeColor3: "#03a9f4", ThemeName: "Classic - Lavender" },
		{ThemeValue: "classic-lavender-dark", 	ThemeColor1: "#a4008c",ThemeColor2: "#2c232b",ThemeColor3: "#03a9f4", ThemeName: "Classic - Lavender Dark" },
		{ThemeValue: "classic-opal", 			ThemeColor1: "#7bd2f6",ThemeColor2: "#daecf4",ThemeColor3: "#03a9f4", ThemeName: "Classic - Opal" },
		{ThemeValue: "classic-opal-dark", 		ThemeColor1: "#0066cc",ThemeColor2: "#2a2a2a",ThemeColor3: "#03a9f4", ThemeName: "Classic - Opal Dark" },
		{ThemeValue: "classic-silver", 			ThemeColor1: "#1984c8",ThemeColor2: "#f3f3f4",ThemeColor3: "#03a9f4", ThemeName: "Classic - Silver" },
		{ThemeValue: "classic-silver-dark", 	ThemeColor1: "#1984c8",ThemeColor2: "#131314",ThemeColor3: "#03a9f4", ThemeName: "Classic - Silver Dark" },
		{ThemeValue: "classic-uniform", 		ThemeColor1: "#818181",ThemeColor2: "#e9e9e9",ThemeColor3: "#03a9f4", ThemeName: "Classic - Uniform" }
    ];

    // Initialize Chart Theme dropdown
    $("#ew_chart_theme").kendoDropDownList({
        dataTextField:"ThemeName",
        dataValueField:"ThemeValue",
        dataSource: data_ew_chart_theme,
		value: $("#li_chart_theme").data("chart-theme"),
		autoWidth: true,
		height: 300,
		template: `
                <div style="margin-top: -15px">
					<span class="chart-color-box" style="background-color: #:data.ThemeColor1#;"></span>
                    <span class="chart-color-box" style="background-color: #:data.ThemeColor2#;"></span>
                    <span class="chart-color-box" style="background-color: #:data.ThemeColor3#;"></span>
                    <span style="display: block; width: 100%">#:data.ThemeName#</span>
                </div>
            `, 
        filter:"contains"
    });

});

/** Functions **/

//populate the datasource label from the hidden dropdowns
function populate_datasource_title(){
	var chart_datasource = $("#ew_datasource_title").text();
	var datasource_title = '';
	var chart_type = $("#ew_main_list").data("charttype");
	
	if(chart_type == 'grid'){
		datasource_title = 'All fields';
	}else{
		datasource_title = $("#ew_select_datasource option[value=" + chart_datasource + "]").text();
		if($("#ew_select_datasource option[value=" + chart_datasource + "]").parent().attr('label') != null){
				datasource_title = datasource_title + ' (' + $("#ew_select_datasource option[value=" + chart_datasource + "]").parent().attr('label') + ')';	
		}
	}

	$("#ew_datasource_title").text(datasource_title);
}

function select_date(dates){
	var month = dates[0].getMonth() + 1;
	var day   = dates[0].getDate();
	var year  = dates[0].getFullYear();
	
	var temp = $(this).attr("id").split("_");
	var li_id = temp[1];

	var selected_date = month + '/' + day + '/' + year;

	$("#filterkeyword_" + li_id).val(selected_date);
	$("#li_" + li_id).data('filter_properties').keyword = selected_date;
}
function select_date_range_start(dates){
	var month = dates[0].getMonth() + 1;
	var day   = dates[0].getDate();
	var year  = dates[0].getFullYear();
	
	var temp = $(this).attr("id").split("_");
	var li_id = temp[1];

	var selected_date = month + '/' + day + '/' + year;

	$("#ew_chart_date_range_start").val(selected_date);
}
function select_date_range_end(dates){
	var month = dates[0].getMonth() + 1;
	var day   = dates[0].getDate();
	var year  = dates[0].getFullYear();
	
	var temp = $(this).attr("id").split("_");
	var li_id = temp[1];

	var selected_date = month + '/' + day + '/' + year;

	$("#ew_chart_date_range_end").val(selected_date);
}